/*
 * Decompiled with CFR 0.152.
 */
package processing.phone;

import javax.microedition.lcdui.Display;
import processing.core.PCanvas;
import processing.core.PMIDlet;

public class Phone {
    private PMIDlet midlet;
    private PCanvas canvas;
    private Display display;

    public Phone(PMIDlet pMIDlet) {
        this.midlet = pMIDlet;
        this.canvas = pMIDlet.canvas;
        this.display = pMIDlet.display;
    }

    public void fullscreen() {
        this.canvas.removeCommand(this.midlet.cmdExit);
        this.canvas.removeCommand(this.midlet.cmdCustom);
        this.canvas.setCommandListener(null);
        this.canvas.setFullScreenMode(true);
        this.midlet.width = this.canvas.getWidth();
        this.midlet.height = this.canvas.getHeight();
    }

    public void noFullscreen() {
        this.canvas.setFullScreenMode(false);
        this.midlet.width = this.canvas.getWidth();
        this.midlet.height = this.canvas.getHeight();
        this.canvas.addCommand(this.midlet.cmdExit);
        this.canvas.addCommand(this.midlet.cmdCustom);
        this.canvas.setCommandListener(this.midlet);
    }

    public boolean vibrate(int n) {
        return this.display.vibrate(n);
    }

    public boolean flash(int n) {
        return this.display.flashBacklight(n);
    }

    public boolean call(String string) {
        return this.launch("tel:" + string);
    }

    public boolean launch(String string) {
        try {
            return this.midlet.platformRequest(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }
}

