/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import processing.core.PMIDlet;

public class PClient
extends InputStream
implements Runnable {
    public static final int EVENT_CONNECTED = 0;
    public static final int EVENT_ERROR = 1;
    private PMIDlet midlet;
    private String server;
    private int port;
    private HttpConnection con;
    private InputStream is;
    private String url;
    private String contentType;
    private byte[] request;

    public PClient() {
    }

    public PClient(String string) {
        this(string, 80);
    }

    public PClient(String string, int n) {
        this.server = string;
        this.port = n;
    }

    public PClient(PMIDlet pMIDlet, String string) {
        this(pMIDlet, string, 80);
    }

    public PClient(PMIDlet pMIDlet, String string, int n) {
        this.midlet = pMIDlet;
        this.server = string;
        this.port = n;
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c) || Character.isLowerCase(c) || Character.isUpperCase(c)) {
                stringBuffer.append(c);
                continue;
            }
            if (c == ' ') {
                stringBuffer.append('+');
                continue;
            }
            stringBuffer.append('%');
            if (c < '\u0010') {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(c));
        }
        return stringBuffer.toString();
    }

    public boolean POST(String string, String[] stringArray, String[] stringArray2) {
        this.url = "http://" + this.server + (this.port != 80 ? ":" + this.port : "") + string;
        this.contentType = "application/x-www-form-urlencoded";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                printStream.print("&");
            }
            printStream.print(PClient.encode(stringArray[i]));
            printStream.print("=");
            printStream.print(PClient.encode(stringArray2[i]));
        }
        this.request = byteArrayOutputStream.toByteArray();
        return this.start();
    }

    public boolean POST(String string, String[] stringArray, Object[] objectArray) {
        this.url = "http://" + this.server + (this.port != 80 ? ":" + this.port : "") + string;
        this.contentType = "multipart/form-data; boundary=BOUNDARY_185629";
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        try {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                printStream.print("--BOUNDARY_185629\r\n");
                printStream.print("Content-Disposition: form-data; name=\"");
                printStream.print(stringArray[i]);
                if (objectArray[i] instanceof String) {
                    printStream.print("\"\r\n");
                    printStream.print("\r\n");
                    printStream.print((String)objectArray[i]);
                    printStream.print("\r\n");
                    continue;
                }
                if (!(objectArray[i] instanceof byte[])) continue;
                byte[] byArray = (byte[])objectArray[i];
                printStream.print("\"; filename=\"");
                printStream.print(stringArray[i]);
                printStream.print("\"\r\n");
                printStream.print("Content-Type: application/octet-stream\r\n");
                printStream.print("Content-Transfer-Encoding: binary\r\n\r\n");
                ((OutputStream)printStream).write(byArray);
                printStream.print("\r\n");
            }
            printStream.print("--BOUNDARY_185629--\r\n\r\n");
            this.request = byteArrayOutputStream.toByteArray();
            return this.start();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public boolean GET(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("?");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("=");
            stringBuffer.append(PClient.encode(stringArray2[i]));
            if (i >= n - 1) continue;
            stringBuffer.append("&");
        }
        return this.GET(stringBuffer.toString());
    }

    public boolean GET(String string) {
        this.url = string.startsWith("http") ? string : "http://" + this.server + (this.port != 80 ? ":" + this.port : "") + string;
        this.contentType = null;
        this.request = null;
        return this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean start() {
        Thread thread = new Thread(this);
        boolean bl = true;
        if (this.midlet == null) {
            String string = this.server;
            synchronized (string) {
                thread.start();
                try {
                    this.server.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                bl = this.is != null;
            }
        }
        thread.start();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.close();
        OutputStream outputStream = null;
        try {
            this.con = (HttpConnection)Connector.open((String)this.url);
            if (this.contentType != null) {
                this.con.setRequestMethod("POST");
                this.con.setRequestProperty("Content-Type", this.contentType);
            } else {
                this.con.setRequestMethod("GET");
            }
            this.con.setRequestProperty("Connection", "close");
            if (this.request != null) {
                outputStream = this.con.openOutputStream();
                outputStream.write(this.request);
                outputStream.flush();
                outputStream.close();
                outputStream = null;
            }
            this.is = this.con.openInputStream();
            if (this.midlet != null) {
                this.midlet.enqueueLibraryEvent(this, 0, null);
            }
        }
        catch (IOException iOException) {
            this.close();
            if (this.midlet != null) {
                this.midlet.enqueueLibraryEvent(this, 1, null);
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
                outputStream = null;
            }
        }
        if (this.midlet == null) {
            String string = this.server;
            synchronized (string) {
                this.server.notify();
            }
        }
    }

    public int read() {
        int n = -1;
        try {
            if (this.is != null) {
                n = this.is.read();
            }
        }
        catch (IOException iOException) {
            this.close();
        }
        return n;
    }

    public char readChar() {
        return (char)this.read();
    }

    public byte[] readBytes() {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            int n = this.is.read(byArray2);
            while (n >= 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
                n = this.is.read(byArray2);
            }
            byArray2 = null;
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
        }
        catch (IOException iOException) {
            this.close();
        }
        return byArray;
    }

    public int readBytes(byte[] byArray) {
        int n = -1;
        if (this.is != null) {
            try {
                n = 0;
                int n2 = byArray.length;
                int n3 = 0;
                do {
                    if ((n3 = this.is.read(byArray, n, n2 - n)) < 0) continue;
                    n += n3;
                } while (n < n2 && n3 >= 0);
            }
            catch (IOException iOException) {
                this.close();
                n = -1;
            }
        }
        return n;
    }

    public String readString() {
        String string = null;
        byte[] byArray = this.readBytes();
        if (byArray != null) {
            string = new String(byArray);
        }
        return string;
    }

    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.con = null;
        }
    }
}

